//
//  ASPingService.h
//  CRMNetDetect
//
//  Created by 坚鹏 on 2024/10/15.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN
@class ASPingService;
@protocol ASPingServiceDelegate <NSObject>

//单次ping回调:成功、超时、出错.
- (void)pingService:(ASPingService*)service singlePing:(uint16_t)seq finishedWithDuration:(NSTimeInterval)millionSeconds;
- (void)pingService:(ASPingService*)service singlePingTimeout:(uint16_t)seq;
- (void)pingService:(ASPingService*)service singlePing:(uint16_t)seq tmporaryErrorHappens:(NSError*)error;

@optional
- (void)pingingServiceDidStart:(ASPingService*)service;//[调用starts]成功
- (void)pingService:(ASPingService*)service stopWithError:(NSError*_Nullable)error successPingCount:(NSInteger)successPingCount;//ping终止，error为空时则为正常终止,若successPingCount为0，你可以考虑使用http替代进行网络检测
@end
@interface ASPingService : NSObject

- (instancetype)initWithDelegate:(id<ASPingServiceDelegate>)delegate;

- (void)starts;

- (void)stops;

@property(nonatomic,assign)BOOL usingICMPv6;//大陆的v6支持有限，一般不建议开启.
@property(nonatomic,assign,readonly)BOOL isPinging;//判断是否在ping中.
@property(nonatomic,copy)NSString * targetHost;//ping目标路径，不能为空.
@property(nonatomic,assign)NSInteger pingCount;//默认为1即只ping一次.
/**
 * @property    timeoutSeconds      单次Ping耗时，默认为2s,超出2s收不到当次ping回调按超时处理;必须大于等于1，小于1则忽略.
 **/
@property(nonatomic,assign)NSTimeInterval timeoutSeconds;
@property(nonatomic,weak,readonly)id<ASPingServiceDelegate>delegate;
@end

NS_ASSUME_NONNULL_END
