//
//  CRMNetDetectService.h
//  CRMNetDetect
//
//  Created by 坚鹏 on 2024/10/14.
//

#import <Foundation/Foundation.h>
#import <ASNetwork/ASNetwork.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger,CRMNetSignalStrength)
{
    CRMNetSignalStrengthUnknown = 0,
    CRMNetSignalStrengthNone,
    CRMNetSignalStrengthStrong,
    CRMNetSignalStrengthWeak
};
@protocol CRMNetDetectServiceDelegate <NSObject>

//连接情况和信号强度一并返回
- (void)didGotNetworkStatus:(ASReachabilityStatus)status signalStrength:(CRMNetSignalStrength)strength;

//ping www.baidu.com，能收到回调表示外网访问正常，IP状态视为正常，否则为异常.
- (void)didGotIPState:(BOOL)isNormal ;

//单个业务服务检测回调
- (void)didGotBusinessServiceState:(BOOL)isNormal
                              host:(NSString*)host
                         hostIndex:(NSInteger)hostIndex millionSeconds:(NSTimeInterval)millionSeconds;

//完成所有业务服务检测回调
- (void)didFinishedBusinessService:(BOOL)isNormal;
@end

@interface CRMNetDetectService : NSObject

-(instancetype)initWithDelegate:(id<CRMNetDetectServiceDelegate>)delegate;

/**
 * @brief   启动网络探测，探测结果通过delegate通知.
 **/
- (void)startsDetecting;
/**
 * @brief   停止网络探测.
 **/
- (void)stopDetecting;

@property(nonatomic,assign,readonly)BOOL isDetecting;
@property(nonatomic,strong,nullable)NSArray<NSString*>*businessHostList;
@property(nonatomic,weak,readonly)id<CRMNetDetectServiceDelegate>delegate;
@end

NS_ASSUME_NONNULL_END
