//
//  ASAppDelegate.m
//  CRMNetDetect
//
//  Created by guojianpeng@svinvy.com on 10/14/2024.
//  Copyright (c) 2024 guojianpeng@svinvy.com. All rights reserved.
//

#import "ASAppDelegate.h"
#import "ASIPService.h"


@implementation ASAppDelegate
{
    ASReachability * _reachability;
    ASPingService *_pingService;
}

- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions
{
    // Override point for customization after application launch.
    ASIPService*service = [ASIPService new];
    [service updateAvailableIPList];
    NSLog(@"当前网络下\n%@",service.availableIPList);
    _reachability = [[ASReachability alloc] initWithDelegate:self];
    [_reachability startsObserving];
    _pingService = [[ASPingService alloc] initWithDelegate:self];
    _pingService.pingCount = 10;
    _pingService.timeoutSeconds = 2;
    _pingService.targetHost = @"ebank.sdb.com.cn";
    [_pingService starts];
    return YES;
}

- (void)applicationWillResignActive:(UIApplication *)application
{
    // Sent when the application is about to move from active to inactive state. This can occur for certain types of temporary interruptions (such as an incoming phone call or SMS message) or when the user quits the application and it begins the transition to the background state.
    // Use this method to pause ongoing tasks, disable timers, and throttle down OpenGL ES frame rates. Games should use this method to pause the game.
}

- (void)applicationDidEnterBackground:(UIApplication *)application
{
    // Use this method to release shared resources, save user data, invalidate timers, and store enough application state information to restore your application to its current state in case it is terminated later.
    // If your application supports background execution, this method is called instead of applicationWillTerminate: when the user quits.
}

- (void)applicationWillEnterForeground:(UIApplication *)application
{
    // Called as part of the transition from the background to the inactive state; here you can undo many of the changes made on entering the background.
}

- (void)applicationDidBecomeActive:(UIApplication *)application
{
    // Restart any tasks that were paused (or not yet started) while the application was inactive. If the application was previously in the background, optionally refresh the user interface.
}

- (void)applicationWillTerminate:(UIApplication *)application
{
    // Called when the application is about to terminate. Save data if appropriate. See also applicationDidEnterBackground:.
}

- (void)reachabilityBecomesNotReachable:(nonnull ASReachability *)ability { 
    
}

- (void)reachabilityChangedToWWAN:(nonnull ASReachability *)ability type:(ASCellularType)type signalStrength:(ASCelluarSignalStrength)strength { 
    ASIPService*service = [ASIPService new];
    [service updateAvailableIPList];
    NSLog(@"celluar ip:%@",service.getCelluarIP);
}

- (void)reachabilityChangedToWiFi:(nonnull ASReachability *)ability { 
    ASIPService*service = [ASIPService new];
    [service updateAvailableIPList];
    NSLog(@"wifi ip:%@",service.getWiFiIP);
}

- (void)pingService:(nonnull ASPingService *)service pingTimeout:(uint16_t)seq { 
    
}

- (void)pingService:(nonnull ASPingService *)service pingingWithDuration:(NSTimeInterval)millionSeconds seq:(uint16_t)seq { 
    
}

- (void)pingService:(nonnull ASPingService *)service tmporaryErrorHappens:(nonnull NSError *)error seq:(uint16_t)seq { 
    
}
-(void)pingService:(ASPingService *)service stopWithError:(NSError *)error
{
    if(![service.targetHost isEqualToString:@"svinvy.com"]){
        _pingService.targetHost = @"svinvy.com";
        [_pingService starts];
    }
    
}
@end
