//
//  CRMNetDetectService.h
//  CRMNetDetect
//
//  Created by 坚鹏 on 2024/10/14.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger,CRMNetSignalLevel){
    CRMNetSignalLevelUnknown = 0,
    CRMNetSignalLevelStrong,
    CRMNetSignalLevelWeak
};
@class CRMNetDetectService;
@protocol CRMNetDetectServiceDelegate <NSObject>

- (void)netDetect:(CRMNetDetectService*)service signalLevelChanged:(CRMNetSignalLevel)level;
@end
@interface CRMNetDetectService : NSObject
/**
 * @return  是否检测中的标识，在调用[startsDetecting]后为true,初始状态或[stopDetecting]后为false
 **/
- (BOOL)isDetectStarted;
/**
 * @brief   启动网络探测，探测结果通过delegate通知.
 **/
- (void)startsDetecting;
/**
 * @brief   停止网络探测.
 **/
- (void)stopDetecting;
@end

NS_ASSUME_NONNULL_END
