//
//  ASReachability.h
//  CRMNetDetect
//
//  Created by 坚鹏 on 2024/10/14.
//

#import <Foundation/Foundation.h>
#import <CRMNetDetect/ASCellularService.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger,ASReachabilityStatus){
    ASReachabilityStatusUnknown = 0,
    ASReachabilityStatusNotReachable,
    ASReachabilityStatusWWAN,
    ASReachabilityStatusWifi
};
@class ASReachability;
@protocol ASReachabilityDelegate <NSObject>

- (void)reachabilityBecomesNotReachable:(ASReachability*)ability;
- (void)reachabilityChangedToWiFi:(ASReachability*)ability;
- (void)reachabilityChangedToWWAN:(ASReachability*)ability
                             type:(ASCellularType)type signalStrength:(ASCelluarSignalStrength)strength;
@end
@interface ASReachability : NSObject

- (instancetype)initWithDelegate:(id<ASReachabilityDelegate>)delegate;

- (void)startsObserving;

- (void)stopObserving;


@property(nonatomic,copy,nullable)NSString * host;
@property(nonatomic,assign,readonly)ASReachabilityStatus status;
@property(nonatomic,weak,readonly)id<ASReachabilityDelegate>delegate;
@end

NS_ASSUME_NONNULL_END
