//
//  ASIPService.h
//  CRMNetDetect
//
//  Created by 坚鹏 on 2024/10/15.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN
typedef NS_ENUM(NSInteger,ASIPType)
{
    ASIPTypeUnknown = 0,
    ASIPTypeWiFi,//Wifi
    ASIPTypeCelluar,//蜂窝
    ASIPTypeVPN,//VPN
    ASIPTypeEthernet,//以太
    ASIPTypeLo0,//本地环回
    ASIPTypeBridge0,//热点
};
@interface ASIPEntity : NSObject

@property(nonatomic,copy,readonly)NSString*value;
@property(nonatomic,assign,readonly)ASIPType type;
@property(nonatomic,assign,readonly)BOOL isIpv4;
@property(nonatomic,assign,readonly)BOOL isIpv6;
@property(nonatomic,assign,readonly)BOOL isPrivateIP;//是否局域网私有IP
@property(nonatomic,assign,readonly)BOOL isLinkLocalIP;//是否自分配IP，169.254开头
@end

@interface ASIPService : NSObject

- (void)updateAvailableIPList;

- (BOOL)usingVPN;

//ipv4+ipv6可能同时启用
- (NSArray<NSString*>* _Nullable)getWiFiIP;

//ipv4+ipv6可能同时启用或多sim卡
- (NSArray<NSString*>*_Nullable)getCelluarIP;

@property(nonatomic,strong,readonly,nullable)NSArray<ASIPEntity*>*availableIPList;
@end

NS_ASSUME_NONNULL_END
