//
//  ASCellularSignalMonitor.h
//  CRMNetDetect
//
//  Created by 坚鹏 on 2024/10/14.
//

#import <Foundation/Foundation.h>
#import <CoreTelephony/CTTelephonyNetworkInfo.h>
#import <CoreTelephony/CTCarrier.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger,ASCellularType)
{
    ASCellularTypeUnknown = 0,
    ASCellularType2G,
    ASCellularType3G,
    ASCellularType4G,
    ASCellularType5G API_AVAILABLE(ios(14.1))//iPhone12以上系列
};
typedef NS_ENUM(NSInteger,ASCelluarSignalStrength){
    ASCelluarSignalStrengthUnknown = 0,
    ASCelluarSignalStrengthStrong,
    ASCelluarSignalStrengthWeak
};
@interface ASCellularService : NSObject

- (NSString*)accessTypeValue;

- (ASCellularType)accessType;

- (ASCelluarSignalStrength)signalStrength;

- (ASCelluarSignalStrength)signalStrengthEvaluatedForType:(ASCellularType)type;
@end

NS_ASSUME_NONNULL_END
