//
//  ASCellularSignalMonitor.m
//  ASNetwork
//
//  Created by 坚鹏 on 2024/10/14.
//

#import "ASCellularNet.h"

@implementation ASCellularNet
{
    NSString * _accessTypeValue;
    ASCellularNetType _accessType;
    ASCelluarSignalStrength _signalStrength;
}
-(instancetype)init{
    if(self = [super init]){
        [self updateNetworkInfo];
    }return _accessTypeValue ? self : nil;
}
-(void)updateNetworkInfo
{
    CTTelephonyNetworkInfo *networkInfo = [[CTTelephonyNetworkInfo alloc] init];
    NSString *radioAccessTechnology = nil;
    if (@available(iOS 12.0, *)) {
        // iOS 12 及以上版本，获取当前网络类型
        NSDictionary *serviceRadioAccessTech = [networkInfo serviceCurrentRadioAccessTechnology];
        radioAccessTechnology = serviceRadioAccessTech.allValues.firstObject;
    } else {
        // iOS 12 以下，直接获取当前网络类型
        radioAccessTechnology = networkInfo.currentRadioAccessTechnology;
    }
    _accessTypeValue = radioAccessTechnology;
    _accessType = [self _parsedAccessType];
    _signalStrength = [self _mapSignalStrengthEvaluatedForType:_accessType];
}
-(NSString *)typeValue
{
    return _accessTypeValue;
}
-(ASCellularNetType)type
{
    return _accessType;
}
-(ASCelluarSignalStrength)signalStrength
{
    return _signalStrength;
}
#pragma mark - Utils
-(ASCellularNetType)_parsedAccessType
{
    ASCellularNetType type = ASCellularTypeUnknown;
    NSString * value = [self typeValue];
    NSArray * secondGValues = @[
        CTRadioAccessTechnologyEdge,CTRadioAccessTechnologyGPRS
    ];
    if([secondGValues containsObject:value]){return ASCellularType2G;}
    NSArray * threeGValues = @[
        CTRadioAccessTechnologyHSDPA,CTRadioAccessTechnologyHSUPA,
        CTRadioAccessTechnologyWCDMA,CTRadioAccessTechnologyCDMA1x
    ];
    if([threeGValues containsObject:value]){return ASCellularType3G;}
    else if ([value isEqualToString:CTRadioAccessTechnologyLTE]){
        return ASCellularType4G;
    }else{
        if (@available(iOS 14.1, *)) {
            NSArray * fiveGValues = @[
                CTRadioAccessTechnologyNRNSA,CTRadioAccessTechnologyNR
            ];
            if([fiveGValues containsObject:value]){return ASCellularType5G;}
        }
    }
    return type;
}

-(ASCelluarSignalStrength)_mapSignalStrengthEvaluatedForType:(ASCellularNetType)type
{
    if (@available(iOS 14.1, *)) {
        if(type == ASCellularType5G){
            return ASCelluarSignalStrengthStrong;
        }
    }else if (type == ASCellularType4G){
        return ASCelluarSignalStrengthStrong;
    }else if (type == ASCellularType3G || type == ASCellularType2G){
        return ASCelluarSignalStrengthWeak;
    }else{
        return ASCelluarSignalStrengthUnknown;
    }
    return ASCelluarSignalStrengthUnknown;
}
@end
