//
//  ASCellularSignalMonitor.h
//  ASNetwork
//
//  Created by 坚鹏 on 2024/10/14.
//

#import <Foundation/Foundation.h>
#import <CoreTelephony/CTTelephonyNetworkInfo.h>
#import <CoreTelephony/CTCarrier.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger,ASCellularNetType)
{
    ASCellularTypeUnknown = 0,
    ASCellularType2G,
    ASCellularType3G,
    ASCellularType4G,
    ASCellularType5G API_AVAILABLE(ios(14.1))//iPhone12以上系列
};
typedef NS_ENUM(NSInteger,ASCelluarSignalStrength){
    ASCelluarSignalStrengthUnknown = 0,
    ASCelluarSignalStrengthStrong,
    ASCelluarSignalStrengthWeak
};
@interface ASCellularNet : NSObject
/**
 * @brief   当前蜂窝网接入信息，若无蜂窝接入信息则返回nil.
 **/
- (nullable instancetype)init;
/**
 * @brief   接入网络类型系统描述，包括CTRadioAccessTechnologyEdge等
 **/
@property(nonatomic,copy,readonly)NSString * typeValue;
/**
 * @brief   accessNetValue的枚举映射.
 **/
@property(nonatomic,assign,readonly)ASCellularNetType type;
/**
 * @brief   信号强度。基于accessNet的一个估算，默认4G/5G为strong,其余为weak；
 *          若想检测相应域名连接是否稳定、快速(强弱网)，你应当使用icmp/http进行检测RTT等耗时
 **/
@property(nonatomic,assign,readonly)ASCelluarSignalStrength signalStrength;
@end

NS_ASSUME_NONNULL_END
