//
//  CRMNetDetectView.m
//  CRMNetDetect
//
//  Created by 坚鹏 on 2024/10/17.
//

#import "CRMNetDetectView.h"
#import <CRMNetDetect/CRMNetDetectService.h>
#import <CRMNetDetect/CRMNetDetectCell.h>

@interface CRMNetDetectView()<CRMNetDetectServiceDelegate,UITableViewDataSource>
{
    CRMNetDetectCellData *_signalStrengthData,*_reachabilityData,*_ipData,*_serverConnectData;
    int _staticCellDataCount;
}
@property(nonatomic,strong)UITableView * tableView;
@property(nonatomic,strong)UIButton * checkButton;
@property(nonatomic,strong)UIImageView * signalImageView;
@property(nonatomic,strong)NSMutableArray<CRMNetDetectCellData*>*cellDatas;
@end

@implementation CRMNetDetectView
{
    CRMNetDetectService * _service;
    NSArray<NSDictionary*>*_businessHostInfo;
}
-(instancetype)initWithFrame:(CGRect)frame{
    if(self = [super initWithFrame:frame]){
        [self _initBaseCellData];
        _service = [[CRMNetDetectService alloc] initWithDelegate:self];
        _tableView = [[UITableView alloc] initWithFrame:frame];
        _tableView.backgroundColor = [UIColor colorWithRed:243/255.0 green:243/255.0 blue:243/255.0 alpha:1];
        _tableView.dataSource = self;
        _tableView.rowHeight = 44;
        _tableView.tableFooterView = [self _footView];
        _tableView.tableHeaderView = [self _headView];
        [self addSubview:_tableView];
    }return self;
}
- (void)_initBaseCellData
{
    _cellDatas = @[].mutableCopy;
    _staticCellDataCount = 0;
    _signalStrengthData = [[CRMNetDetectCellData alloc] init];
    _signalStrengthData.leftTitle = @"网络连接信号强度";
    _staticCellDataCount++;
    _reachabilityData = [[CRMNetDetectCellData alloc] init];
    _reachabilityData.leftTitle = @"网络连接情况";
    _staticCellDataCount++;
    _ipData = [[CRMNetDetectCellData alloc] init];
    _ipData.leftTitle = @"IP状态";
    _staticCellDataCount++;
    _serverConnectData = [[CRMNetDetectCellData alloc] init];
    _serverConnectData.leftTitle = @"服务器连接情况(Link-GL-kong-grev)";
    _staticCellDataCount++;
    [_cellDatas addObjectsFromArray:@[_signalStrengthData,_reachabilityData,
                                      _ipData,_serverConnectData]];
}
#pragma mark - UITableViewDataSource
-(NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return _cellDatas.count;
}
-(UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    CRMNetDetectCell * cell = [[CRMNetDetectCell alloc] initWithFrame:CGRectZero];
    cell.backgroundColor = UIColor.whiteColor;
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    [cell updateData:_cellDatas[indexPath.row]];
    return cell;
}
#pragma mark - Interface
-(void)startsChecking
{
    [self setBusinessHosts:_businessHostInfo];
    [_service startsDetecting];
}
-(void)setBusinessHosts:(NSArray<NSDictionary *> *)hosts
{
    _businessHostInfo = hosts;
    if(_cellDatas.count){
        [self _initBaseCellData];
    }
    NSMutableArray * hostList = @[].mutableCopy;
    for (int i =0; i<hosts.count; i++) {
        NSDictionary * info = hosts[i];
        NSString * name = info[@"name"];
        NSString * host = info[@"host"];
        if(![host isKindOfClass:NSString.class] || !host.length){
            continue;
        }
        [hostList addObject:host];
        CRMNetDetectCellData*data = [[CRMNetDetectCellData alloc] init];
        data.leftTitle = name;
        [_cellDatas addObject:data];
    }
    _service.businessHostList = hostList;
}
#pragma mark -CRMNetDetectServiceDelegate
- (void)didGotNetworkStatus:(ASReachabilityStatus)status signalStrength:(CRMNetSignalStrength)strength
{
    _reachabilityData.state = (status == ASReachabilityStatusWifi ||(status == ASReachabilityStatusWWAN))?CRMNetDetectCellStateNormal:CRMNetDetectCellStateNotNormal;
    _signalStrengthData.state = (strength==CRMNetSignalStrengthNone)?CRMNetDetectCellStateNotNormal:CRMNetDetectCellStateNormal;
    if(status == ASReachabilityStatusNotReachable){
        _signalStrengthData.rightText = @"无";
    }else{
        _signalStrengthData.rightText =(strength==CRMNetSignalStrengthStrong)?@"强":@"弱";
    }
    [self.tableView reloadData];
}
- (void)didGotIPState:(BOOL)isNormal
{
    _ipData.state = isNormal ? CRMNetDetectCellStateNormal :CRMNetDetectCellStateNotNormal;
    [self.tableView reloadData];
}
- (void)didGotBusinessServiceState:(BOOL)isNormal host:(nonnull NSString *)host hostIndex:(NSInteger)hostIndex millionSeconds:(NSTimeInterval)millionSeconds
{
    CRMNetDetectCellData * data = _cellDatas[hostIndex+_staticCellDataCount];
    data.state = isNormal? CRMNetDetectCellStateNormal :CRMNetDetectCellStateNotNormal;
    data.rightText = isNormal ? [NSString stringWithFormat:@"正常 %ld ms",(NSInteger)millionSeconds] : @"异常";
    [self.tableView reloadData];
}
- (void)didFinishedBusinessService:(BOOL)isNormal
{
    _serverConnectData.state =isNormal? CRMNetDetectCellStateNormal :CRMNetDetectCellStateNotNormal;
    [self.tableView reloadData];
}
#pragma mark - Getters
-(UIButton *)checkButton
{
    if(!_checkButton){
        _checkButton = [[UIButton alloc] init];
        _checkButton.layer.cornerRadius = 3;
        _checkButton.backgroundColor = [UIColor colorWithRed:238/255.0 green:131/255.0 blue:68/255.0 alpha:1];
        [_checkButton setTitle:@"重新检测" forState:UIControlStateNormal];
        [_checkButton setTitleColor:UIColor.whiteColor forState:UIControlStateNormal];
        [_checkButton.titleLabel setFont:[UIFont systemFontOfSize:14]];
        [_checkButton addTarget:self action:@selector(startsChecking) forControlEvents:UIControlEventTouchUpInside];
    }return _checkButton;
}
- (UIView*)_footView
{
    CGFloat marginTop = 50;
    CGFloat marginBottom = 20;
    CGFloat btnHeight = 40;
    UIButton * btn = self.checkButton;
    UIView * view = [[UIView alloc] initWithFrame:CGRectMake(0, 0, self.bounds.size.width, marginTop+marginBottom+btnHeight)];
    [view addSubview:btn];
    btn.frame = CGRectMake(20, marginTop, view.bounds.size.width-40, btnHeight);
    return view;
}
- (UIView*)_headView
{
    CGFloat marginTop = 20;
    CGFloat marginBottom = 30;
    CGFloat btnHeight = 100;
    CGFloat seperateHeight = 15;
    UIView * view = [[UIView alloc] initWithFrame:CGRectMake(0, 0, self.bounds.size.width, marginTop+marginBottom+btnHeight+seperateHeight)];
    view.backgroundColor = UIColor.whiteColor;
    UIView * seperateView = [[UIView alloc] initWithFrame:CGRectMake(0, view.bounds.size.height-seperateHeight, view.bounds.size.width, seperateHeight)];
    seperateView.backgroundColor = [UIColor colorWithRed:243/255.0 green:243/255.0 blue:243/255.0 alpha:1];
    [view addSubview:seperateView];
    return view;
}
@end
