//
//  CRMNetDetectService.m
//  CRMNetDetect
//
//  Created by 坚鹏 on 2024/10/14.
//

#import "CRMNetDetectService.h"

@interface CRMNetDetectService()<ASPingServiceDelegate,ASReachabilityDelegate>
{
    NSInteger _successPingHostCount;
    ASReachability *_reachability;
    ASPingService *_pingService;
    NSMutableArray <NSString*>*_pingingHostList;
}
@end

@implementation CRMNetDetectService

-(void)dealloc
{
    [self stopDetecting];
}
-(instancetype)initWithDelegate:(id<CRMNetDetectServiceDelegate>)delegate
{
    if(self = [super init]){
        _delegate = delegate;
    }return self;
}
-(void)startsDetecting
{
    if(_isDetecting){return;}
    _isDetecting = true;
    //先检测网络态，再检测具体业务域名
    [self _startReachabilityService];
}
-(void)stopDetecting
{
    _isDetecting = false;
    [self _stopReachabilityService];
    [self _stopPingService];
    _successPingHostCount = 0;
}
#pragma mark - ASPingServiceDelegate
-(void)pingService:(ASPingService *)service singlePing:(uint16_t)seq finishedWithDuration:(NSTimeInterval)millionSeconds
{
    if(!_businessHostList){return;}
    NSInteger index = [_businessHostList indexOfObject:service.targetHost];
    if(index==NSNotFound){
        return;//在处理www.baidu.com
    }
    [self.delegate didGotBusinessServiceState:true host:service.targetHost hostIndex:index millionSeconds:millionSeconds];
    [_pingingHostList removeObject:service.targetHost];
}
-(void)pingService:(ASPingService *)service singlePingTimeout:(uint16_t)seq
{
    if(!_businessHostList){return;}
    NSInteger index = [_businessHostList indexOfObject:service.targetHost];
    if(index==NSNotFound){
        return;//在处理www.baidu.com
    }
    [_pingingHostList removeObject:service.targetHost];
    [self.delegate didGotBusinessServiceState:false host:service.targetHost hostIndex:index millionSeconds:0];
}
-(void)pingService:(ASPingService *)service singlePing:(uint16_t)seq tmporaryErrorHappens:(NSError *)error
{
    if(!_businessHostList){return;}
    NSInteger index = [_businessHostList indexOfObject:service.targetHost];
    if(index==NSNotFound){
        return;//在处理www.baidu.com
    }
    [_pingingHostList removeObject:service.targetHost];
    [self.delegate didGotBusinessServiceState:false host:service.targetHost hostIndex:index millionSeconds:0];
}
- (void)pingService:(ASPingService*)service stopWithError:(NSError*_Nullable)error successPingCount:(NSInteger)successPingCount
{
    if([service.targetHost isEqualToString:@"www.baidu.com"]){
        [self.delegate didGotIPState:successPingCount>0];
        //开始业务ping
        _pingingHostList = _businessHostList.mutableCopy;
        _pingService.pingCount = 1;
    }
    [self _readHostAndPing];
}

#pragma mark - Ping
- (void)_readHostAndPing
{
    if(!_pingService){
        _pingService = [[ASPingService alloc] initWithDelegate:self];
    }
    if (!_pingingHostList.count){
        [self.delegate didFinishedBusinessService:_successPingHostCount == _businessHostList.count];
        [self stopDetecting];
        return;
    }
    _pingService.targetHost = _pingingHostList.firstObject;
    _pingService.pingCount = 1;
    _pingService.timeoutSeconds = 2;
    [_pingService starts];
}
- (void)_stopPingService
{
    _successPingHostCount = 0;
    [_pingingHostList removeAllObjects];
    if(_pingService){
        [_pingService stops];_pingService = nil;
    }
}
- (void)_startReachabilityService
{
    _reachability = [[ASReachability alloc] initWithDelegate:self];
    [_reachability startsObserving];
}
- (void)_stopReachabilityService
{
    if(_reachability){
        [_reachability stopObserving];
    }
}
- (BOOL)_isWifiIPNormal
{
    ASNetworkInterfaceInfo * info = [[ASNetworkInterfaceInfo alloc] init];
    NSArray<NSString *> *wifiIPs = [info getWiFiIPAndOnlyIPV4:true];
    if(!wifiIPs.count){
        return false;
    }
    for (ASIPEntity*ipEntity in wifiIPs) {
        if(ipEntity.isLinkLocalIP){return false;}
    }
    return true;
}
- (BOOL)_isCelluarIPNormal
{
    ASNetworkInterfaceInfo * info = [[ASNetworkInterfaceInfo alloc] init];
    NSArray<NSString *> *cellularIps = [info getCelluarIPAndOnlyIPV:true];
    if(!cellularIps.count){
        return false;
    }
    for (ASIPEntity*ipEntity in cellularIps) {
        if(ipEntity.isPrivateIP){return false;}
    }
    return true;
}
#pragma mark - ASReachabilityDelegate
- (void)reachabilityStatusDidChanged:(ASReachabilityStatus)status statusDesc:(nonnull NSString *)desc {
    NSLog(@"reachability status desc:%@",desc);
    if(status == ASReachabilityStatusNotReachable){
        [self.delegate didGotNetworkStatus:status signalStrength:CRMNetSignalStrengthNone];
    }else if (status == ASReachabilityStatusWifi){
        [self.delegate didGotNetworkStatus:status signalStrength:CRMNetSignalStrengthStrong];
    }else if (status == ASReachabilityStatusWWAN){
        ASCellularNet * celluarNet = [[ASCellularNet alloc] init];
        CRMNetSignalStrength strength = CRMNetSignalStrengthNone;
        if(celluarNet){
            strength = (celluarNet.signalStrength==ASCelluarSignalStrengthStrong?CRMNetSignalStrengthStrong:CRMNetSignalStrengthWeak);
        }
        [self.delegate didGotNetworkStatus:status signalStrength:strength];
    }else{
        //preserved
    }
    [self _stopReachabilityService];
    _pingService = [[ASPingService alloc] initWithDelegate:self];
    _pingService.targetHost = @"www.baidu.com";
    _pingService.pingCount = 3;
    [_pingService starts];
}
@end
