//
//  ASReachability.h
//  ASNetwork
//
//  Created by 坚鹏 on 2024/10/14.
//

#import <Foundation/Foundation.h>
#import <ASNetwork/ASCellularNet.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger,ASReachabilityStatus){
    ASReachabilityStatusUnknown = 0,
    ASReachabilityStatusNotReachable,
    ASReachabilityStatusWWAN,
    ASReachabilityStatusWifi
};
@class ASReachability;
@protocol ASReachabilityDelegate <NSObject>

- (void)reachabilityBecomesNotReachable:(ASReachability*)ability;
/**
 * @brief   使用Wifi时回调；可考虑使用ASInterfaceService.getWiFiIP进一步获取对应IP
 **/
- (void)reachabilityChangedToWiFi:(ASReachability*)ability;
/**
 * @brief   使用蜂窝时回调；可考虑使用ASInterfaceService.getCelluarIP进一步获取对应IP
 **/
- (void)reachabilityChangedToWWAN:(ASReachability*)ability
                             type:(ASCellularNetType)type signalStrength:(ASCelluarSignalStrength)strength;
@end
/**
 * @class   当前activate network探测.
 **/
@interface ASReachability : NSObject

/**
 * @param   delegate        network变动的观察者，会持续收到变动通知，若只想收到一次通知则需在收到通知后主动stopObserving
 **/
- (instancetype)initWithDelegate:(id<ASReachabilityDelegate>)delegate;
/**
 * 开始监测activate network的变动。涉及Wifi接入、流量切换等场景.
 **/
- (void)startsObserving;
/**
 * 停止检测activate network的变动.
 **/
- (void)stopObserving;
/**
 * @property    host        探测目标地址的连通性，对于处于网络策略较为复杂的网段时，会更加有效；可选项.
 **/
@property(nonatomic,copy,nullable)NSString * host;
/**
 * @property    status      当前activate network的状态.
 **/
@property(nonatomic,assign,readonly)ASReachabilityStatus status;
@property(nonatomic,weak,readonly)id<ASReachabilityDelegate>delegate;
@end

NS_ASSUME_NONNULL_END
