//
//  ASIPService.h
//  ASNetwork
//
//  Created by 坚鹏 on 2024/10/15.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN
typedef NS_ENUM(NSInteger,ASIPType)
{
    ASIPTypeUnknown = 0,
    ASIPTypeWiFi,//Wifi
    ASIPTypeCelluar,//蜂窝
    ASIPTypeVPN,//VPN
    ASIPTypeEthernet,//以太
    ASIPTypeLo0,//本地环回
    ASIPTypeBridge0,//热点
    //...Preserved：其余暂时不作映射，统一按Unknown处理.
};
@interface ASIPEntity : NSObject

@property(nonatomic,copy,readonly)NSString*value;
@property(nonatomic,assign,readonly)ASIPType type;
@property(nonatomic,assign,readonly)BOOL isIpv4;
@property(nonatomic,assign,readonly)BOOL isIpv6;
@property(nonatomic,assign,readonly)BOOL isPrivateIP;//是否局域网私有IP
@property(nonatomic,assign,readonly)BOOL isLinkLocalIP;//是否自分配IP，169.254开头
@end
/**
 * @class       静态查询当前已连接的接口，包括wifi或蜂窝ip等.
 **/
@interface ASInterfaceService : NSObject

/**
 * @brief       刷新可用接口,需主动调用.
 **/
- (void)refreshAvailableInterfaces;

/**
 * @return      是否启用了VPN，若接口中包含了虚拟vpn接口则视为true.
 **/
- (BOOL)usingVPN;

/**
 * @return      获取WIFI对应ip列表，当ipv4+ipv6同时启用时会返回多个.
 **/
- (NSArray<NSString*>* _Nullable)getWiFiIP;

/**
 * @return      查询蜂窝IP，当多种sim卡启用或ipv6启用时也可能返回多个
 **/
- (NSArray<NSString*>*_Nullable)getCelluarIP;

/**
 * @property    可用的接口IP列表
 **/
@property(nonatomic,strong,readonly,nullable)NSArray<ASIPEntity*>*availableIPList;
@end

NS_ASSUME_NONNULL_END
