//
//  CRMNetDetectView.m
//  CRMNetDetect
//
//  Created by 坚鹏 on 2024/10/17.
//

#import "CRMNetDetectView.h"
#import <CRMNetDetect/CRMNetDetectService.h>
#import <CRMNetDetect/CRMNetDetectCell.h>

@interface CRMNetDetectView()<CRMNetDetectServiceDelegate,UITableViewDataSource>
{
    CRMNetDetectCellData *_signalStrengthData,*_reachabilityData,*_ipData,*_serverConnectData;
    int _staticCellDataCount;
}
@property(nonatomic,strong)UITableView * tableView;
@property(nonatomic,strong)UIButton * checkButton;
@property(nonatomic,strong)UIImageView * signalImageView;
@property(nonatomic,strong)NSMutableArray<CRMNetDetectCellData*>*cellDatas;
@end

@implementation CRMNetDetectView
{
    CRMNetDetectService * _service;
}
-(instancetype)initWithFrame:(CGRect)frame{
    if(self = [super initWithFrame:frame]){
        [self _initBaseCellData];
        _service = [[CRMNetDetectService alloc] initWithDelegate:self];
        _tableView = [[UITableView alloc] initWithFrame:frame];
        _tableView.dataSource = self;
        _tableView.rowHeight = 44;
        [self addSubview:_tableView];
    }return self;
}
- (void)_initBaseCellData
{
    _cellDatas = @[].mutableCopy;
    _staticCellDataCount = 0;
    _signalStrengthData = [[CRMNetDetectCellData alloc] init];
    _signalStrengthData.leftTitle = @"网络连接信号强度";
    _staticCellDataCount++;
    _reachabilityData = [[CRMNetDetectCellData alloc] init];
    _reachabilityData.leftTitle = @"网络连接情况";
    _staticCellDataCount++;
    _ipData = [[CRMNetDetectCellData alloc] init];
    _ipData.leftTitle = @"IP状态";
    _staticCellDataCount++;
    _serverConnectData = [[CRMNetDetectCellData alloc] init];
    _serverConnectData.leftTitle = @"服务器连接情况(Link-GL-kong-grev)";
    _staticCellDataCount++;
    [_cellDatas addObjectsFromArray:@[_signalStrengthData,_reachabilityData,
                                      _ipData,_serverConnectData]];
}
#pragma mark - UITableViewDataSource
-(NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return _cellDatas.count;
}
-(UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    CRMNetDetectCell * cell = [[CRMNetDetectCell alloc] initWithFrame:CGRectZero];
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    [cell updateData:_cellDatas[indexPath.row]];
    return cell;
}
#pragma mark - Interface
-(void)startsChecking
{
    [_service startsDetecting];
}
-(void)setBusinessHosts:(NSArray<NSDictionary *> *)hosts
{
    if(_cellDatas.count){
        [self _initBaseCellData];
    }
    NSMutableArray * hostList = @[].mutableCopy;
    for (int i =0; i<hosts.count; i++) {
        NSDictionary * info = hosts[i];
        NSString * name = info[@"name"];
        NSString * host = info[@"host"];
        if(![host isKindOfClass:NSString.class] || !host.length){
            continue;
        }
        [hostList addObject:host];
        CRMNetDetectCellData*data = [[CRMNetDetectCellData alloc] init];
        data.leftTitle = name;
        [_cellDatas addObject:data];
    }
    [self.tableView reloadData];
}
#pragma mark -CRMNetDetectServiceDelegate
- (void)didGotNetworkStatus:(ASReachabilityStatus)status signalStrength:(CRMNetSignalStrength)strength
{
    
}
- (void)didGotIPState:(BOOL)isNormal
{
    
}
- (void)didGotBusinessServiceState:(BOOL)isNormal host:(NSString*)host millionSeconds:(NSTimeInterval)millionSeconds
{
    
}
- (void)didFinishedBusinessService:(BOOL)isNormal
{
    
}
#pragma mark - Getters
-(UIButton *)checkButton
{
    if(!_checkButton){
        _checkButton = [[UIButton alloc] initWithFrame:CGRectMake(20, 40, self.bounds.size.width-40, 40)];
        _checkButton.layer.cornerRadius = 3;
        _checkButton.backgroundColor = UIColor.orangeColor;
        [_checkButton setTitle:@"重新检测" forState:UIControlStateNormal];
        [_checkButton setTitleColor:UIColor.whiteColor forState:UIControlStateNormal];
        [_checkButton.titleLabel setFont:[UIFont systemFontOfSize:14]];
        [_checkButton addTarget:self action:@selector(startsChecking) forControlEvents:UIControlEventTouchUpInside];
    }return _checkButton;
}
@end
