//
//  CRMNetDetectCell.m
//  CRMNetDetect
//
//  Created by 坚鹏 on 2024/10/17.
//

#import "CRMNetDetectCell.h"

@interface CRMNetDetectCell()

@property(nonatomic,strong)UIActivityIndicatorView * indicatorView;
@property(nonatomic,strong)UILabel * titleLabel;
@end

@implementation CRMNetDetectCell
-(void)updateData:(CRMNetDetectCellData *)data
{
    [self setLeftTitle:data.leftTitle];
    if(data.state == CRMNetDetectCellStateNormal){
        [self changeToStateWithRemindMsg:data.rightText pass:true];
    }else if (data.state == CRMNetDetectCellStateNotNormal){
        [self changeToStateWithRemindMsg:data.rightText pass:false];
    }else{
        [self changeToCheckingState];
    }
}
-(void)setLeftTitle:(NSString *)title
{
    [self.contentView addSubview:self.titleLabel];
    [[self.titleLabel.leadingAnchor constraintEqualToAnchor:self.contentView.leadingAnchor constant:20] setActive:true];
    [[self.titleLabel.centerYAnchor constraintEqualToAnchor:self.contentView.centerYAnchor] setActive:true];
    [self.titleLabel setText:title];
}
-(void)changeToCheckingState
{
    [self.contentView addSubview:self.indicatorView];
    [[self.indicatorView.trailingAnchor constraintEqualToAnchor:self.contentView.trailingAnchor constant:-20] setActive:true];
    [[self.indicatorView.centerYAnchor constraintEqualToAnchor:self.contentView.centerYAnchor] setActive:true];
    [_indicatorView startAnimating];
}
-(void)changeToStateWithRemindMsg:(NSString *)msg pass:(BOOL)pass
{
    UILabel * rightLabel = [self createRightLabel:pass];
    rightLabel.text = msg ? : (pass ?@"正常":@"异常");
    [self.contentView addSubview:rightLabel];
    [[rightLabel.trailingAnchor constraintEqualToAnchor:self.contentView.trailingAnchor constant:-20] setActive:true];
    [[rightLabel.centerYAnchor constraintEqualToAnchor:self.contentView.centerYAnchor] setActive:true];
    UIImageView * rightImageView = [[UIImageView alloc] initWithImage:[self _internalImageOfName:pass?@"net_detect_pass":@"net_detect_failed"]];
    rightImageView.translatesAutoresizingMaskIntoConstraints = false;
    [self.contentView addSubview:rightImageView];
    [[rightImageView.trailingAnchor constraintEqualToAnchor:rightLabel.leadingAnchor constant:-3] setActive:true];
    [[rightImageView.centerYAnchor constraintEqualToAnchor:self.contentView.centerYAnchor] setActive:true];
    [[rightImageView.widthAnchor constraintEqualToConstant:18] setActive:true];
    [[rightImageView.heightAnchor constraintEqualToConstant:18] setActive:true];
}
#pragma mark - Getters
-(UILabel *)titleLabel{
    if(!_titleLabel){
        _titleLabel = [[UILabel alloc] init];
        _titleLabel.textColor = UIColor.blackColor;
        _titleLabel.font = [UIFont systemFontOfSize:14];
        _titleLabel.translatesAutoresizingMaskIntoConstraints = false;
    }return _titleLabel;
}
-(UILabel *)createRightLabel:(BOOL)pass{
    UILabel * label = [[UILabel alloc] init];
    label.textColor = pass ? UIColor.greenColor : UIColor.redColor;
    label.font = [UIFont systemFontOfSize:12];
    label.translatesAutoresizingMaskIntoConstraints = false;
    return label;
}
-(UIActivityIndicatorView *)indicatorView{
    if(!_indicatorView){
        if (@available(iOS 13.0, *)) {
            _indicatorView = [[UIActivityIndicatorView alloc] initWithActivityIndicatorStyle:UIActivityIndicatorViewStyleMedium];
        } else {
            _indicatorView = [[UIActivityIndicatorView alloc] initWithActivityIndicatorStyle:UIActivityIndicatorViewStyleGray];
        }
        _indicatorView.translatesAutoresizingMaskIntoConstraints = false;
        _indicatorView.hidesWhenStopped = true;
    }return _indicatorView;
}
- (UIImage*_Nullable)_internalImageOfName:(NSString*)name
{
    NSString*bundlePath = [[NSBundle bundleForClass:self.class] pathForResource:@"CRMNetDetect.bundle" ofType:nil];
    return [UIImage imageWithContentsOfFile:[bundlePath stringByAppendingPathComponent:name]];
}
@end
@implementation CRMNetDetectCellData


@end
