//
//  ASPingService.h
//  CRMNetDetect
//
//  Created by 坚鹏 on 2024/10/15.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN
@class ASPingService;
@protocol ASPingServiceDelegate <NSObject>

- (void)pingService:(ASPingService*)service pingingWithDuration:(NSTimeInterval)millionSeconds seq:(uint16_t)seq;//正常收到回调
- (void)pingService:(ASPingService*)service pingTimeout:(uint16_t)seq;//ping超时，可能来自自身控制，也可能来自icmp通知,这里不做区分
- (void)pingService:(ASPingService*)service tmporaryErrorHappens:(NSError*)error seq:(uint16_t)seq;//可恢复的错误，后续会继续ping

@optional
- (void)pingingServiceDidStart:(ASPingService*)service;//[调用starts]成功
- (void)pingService:(ASPingService*)service failedToStartWithError:(NSError*)error;//调用[starts]失败
- (void)pingService:(ASPingService*)service stopWithError:(NSError*_Nullable)error successPingCount:(NSInteger)successPingCount;//ping终止，error为空时则为正常终止,若successPingCount为0，你可以考虑使用http替代进行网络检测
@end
@interface ASPingService : NSObject

- (instancetype)initWithDelegate:(id<ASPingServiceDelegate>)delegate;

- (void)starts;

- (void)stops;

@property(nonatomic,assign)BOOL usingICMPv6;//大陆的v6支持有限，一般不建议开启.
@property(nonatomic,weak,readonly)id<ASPingServiceDelegate>delegate;
@property(nonatomic,assign,readonly)BOOL isPinging;
@property(nonatomic,copy)NSString * targetHost;
@property(nonatomic,assign)NSInteger pingCount;//默认为1即只ping一次。
@property(nonatomic,assign)NSTimeInterval timeoutSeconds;//默认为2s,超出2s收不到当次ping回调，则取消当次ping,就算后续收到回调也ignore;不建议设置过低.
@end

NS_ASSUME_NONNULL_END
