//
//  CRMNetDetectService.m
//  CRMNetDetect
//
//  Created by 坚鹏 on 2024/10/14.
//

#import "CRMNetDetectService.h"

@interface CRMNetDetectService()<ASPingServiceDelegate,ASReachabilityDelegate>
{
    NSInteger _successPingHostCount;
}
@end

@implementation CRMNetDetectService
{
    ASReachability *_reachability;
    ASInterfaceService *_interfaceService;
    ASPingService *_pingService;
    NSMutableArray <NSString*>*_pingingHostList;
    BOOL _isReachabilityFinished;
}
-(void)dealloc
{
    [self stopDetecting];
}
-(instancetype)initWithDelegate:(id<CRMNetDetectServiceDelegate>)delegate
{
    if(self = [super init]){
        _delegate = delegate;
    }return self;
}
-(void)startsDetecting
{
    if(_isDetecting){return;}
    _isDetecting = true;
    if([_businessHostList count]){
        _pingingHostList = _businessHostList.mutableCopy;
        _pingService = [[ASPingService alloc] initWithDelegate:self];
        [self _readHostAndPing];
    }
    [self _startReachabilityService];
}
-(void)stopDetecting
{
    _isDetecting = false;
    [self _stopPingService];
    [self _stopReachabilityService];
    _isAllFinished = false;
    _interfaceService = nil;
    _isReachabilityFinished = false;
    
}
#pragma mark - ASPingServiceDelegate
- (void)pingService:(ASPingService*)service pingingWithDuration:(NSTimeInterval)millionSeconds seq:(uint16_t)seq
{
    [self.delegate didGotBusinessServiceState:true host:_pingingHostList.firstObject millionSeconds:millionSeconds];
}
- (void)pingService:(ASPingService*)service pingTimeout:(uint16_t)seq
{
    
}
- (void)pingService:(ASPingService*)service tmporaryErrorHappens:(NSError*)error seq:(uint16_t)seq
{
    
}
- (void)pingService:(ASPingService*)service failedToStartWithError:(NSError*)error
{
    [_pingingHostList removeObjectAtIndex:0];
    [self _readHostAndPing];
}
- (void)pingService:(ASPingService*)service stopWithError:(NSError*_Nullable)error successPingCount:(NSInteger)successPingCount
{
    if(!error){
        _successPingHostCount++;
    }else{
        [self.delegate didGotBusinessServiceState:false host:_pingingHostList.firstObject  millionSeconds:0];
    }
}
#pragma mark - ASReachabilityDelegate
- (void)reachabilityBecomesNotReachable:(ASReachability*)ability
{
    _isReachabilityFinished = true;
    [self.delegate didGotNetworkStatus:ability.status signalStrength:CRMNetSignalStrengthNone];
    [self.delegate didGotIPState:false];
}
- (void)reachabilityChangedToWiFi:(ASReachability*)ability
{
    _isReachabilityFinished = true;
    [self.delegate didGotNetworkStatus:ability.status signalStrength:CRMNetSignalStrengthStrong];
    [self _startIPService];
    [self.delegate didGotIPState:[self _isWifiIPNormal]];
}
- (void)reachabilityChangedToWWAN:(ASReachability*)ability
                             type:(ASCellularNetType)type signalStrength:(ASCelluarSignalStrength)strength
{
    _isReachabilityFinished = true;
    [self.delegate didGotNetworkStatus:ability.status signalStrength:strength == ASCelluarSignalStrengthStrong?CRMNetSignalStrengthStrong:CRMNetSignalStrengthWeak];
    [self _startIPService];
    [self.delegate didGotIPState:[self _isCelluarIPNormal]];
}
#pragma mark - Ping
- (void)_readHostAndPing
{
    if(!_pingService){return;}
    else if (!_pingingHostList.count){
        
        [self.delegate didFinishedBusinessService:_successPingHostCount == _businessHostList.count];
        return;
    }
    _pingService.targetHost = _pingingHostList.firstObject;
    _pingService.pingCount = 1;
    _pingService.timeoutSeconds = 2;
    [_pingService starts];
}
- (void)_stopPingService
{
    _successPingHostCount = 0;
    [_pingingHostList removeAllObjects];
    if(_pingService){
        [_pingService stops];_pingService = nil;
    }
}
- (void)_startReachabilityService
{
    _reachability = [[ASReachability alloc] initWithDelegate:self];
    [_reachability startsObserving];
}
- (void)_stopReachabilityService
{
    if(_reachability){
        [_reachability stopObserving];
    }
}
- (void)_startIPService
{
    if(!_interfaceService){
        _interfaceService = [[ASInterfaceService alloc] init];
    }
    [_interfaceService refreshAvailableInterfaces];
}
- (void)stopIPService
{
    _interfaceService = nil;
}
- (BOOL)_isWifiIPNormal
{
    NSArray<NSString *> *wifiIPs = _interfaceService.getWiFiIP;
    if(!wifiIPs.count){
        return false;
    }
    for (ASIPEntity*ipEntity in wifiIPs) {
        if(ipEntity.isLinkLocalIP){return false;}
    }
    return true;
}
- (BOOL)_isCelluarIPNormal
{
    NSArray<NSString *> *cellularIps = _interfaceService.getCelluarIP;
    if(!cellularIps.count){
        return false;
    }
    for (ASIPEntity*ipEntity in cellularIps) {
        if(ipEntity.isPrivateIP){return false;}
    }
    return true;
}
@end
