//
//  CRMNetDetectService.h
//  CRMNetDetect
//
//  Created by 坚鹏 on 2024/10/14.
//

#import <Foundation/Foundation.h>
#import <ASNetwork/ASReachability.h>
#import <ASNetwork/ASCellularNet.h>
#import <ASNetwork/ASPingService.h>
#import <ASNetwork/ASInterfaceService.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger,CRMNetSignalStrength)
{
    CRMNetSignalStrengthUnknown = 0,
    CRMNetSignalStrengthNone,
    CRMNetSignalStrengthStrong,
    CRMNetSignalStrengthWeak
};
@protocol CRMNetDetectServiceDelegate <NSObject>

- (void)didGotNetworkStatus:(ASReachabilityStatus)status signalStrength:(CRMNetSignalStrength)strength;
- (void)didGotIPState:(BOOL)isNormal ;//Wifi下非自有IP则正常，蜂窝下有IP则正常
- (void)didGotBusinessServiceState:(BOOL)isNormal host:(NSString*)host millionSeconds:(NSTimeInterval)millionSeconds;
- (void)didFinishedBusinessService:(BOOL)isNormal;//正常数小于总数，则显示异常
@end

@interface CRMNetDetectService : NSObject

-(instancetype)initWithDelegate:(id<CRMNetDetectServiceDelegate>)delegate;

/**
 * @brief   启动网络探测，探测结果通过delegate通知.
 **/
- (void)startsDetecting;
/**
 * @brief   停止网络探测.
 **/
- (void)stopDetecting;

@property(nonatomic,strong,nullable)NSArray<NSString*>*businessHostList;
@property(nonatomic,assign,readonly)BOOL isDetecting;
@property(nonatomic,weak,readonly)id<CRMNetDetectServiceDelegate>delegate;
@property(nonatomic,assign,readonly)BOOL isAllFinished;
@end

NS_ASSUME_NONNULL_END
