//
//  ASAppleLogin.h
//  ASAppleLogin
//
//  Created by 坚鹏 on 2023/6/19.
//

#import <Foundation/Foundation.h>
#import "ASAppleLoginRequest.h"

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger,ASALSystemButtonStyle)
{
    ASALSystemButtonStyleBlack = 0,//黑底白字
    ASALSystemButtonStyleWhiteOutline,//白底黑字+黑边框
    ASALSystemButtonStyleWhite//白底黑字
};
@interface ASAppleLogin : NSObject

//只支持iOS13以上 
+ (BOOL)isSupported;

//创建自带苹果风格登录按钮
+ (__kindof UIView*_Nullable)createAppleIdAuthorizingButtonForTarget:(id)target action:(SEL)action;
+ (__kindof UIView*_Nullable)createAppleIdAuthorizingButtonForTarget:(id)target action:(SEL)action style:(ASALSystemButtonStyle)style;

//请求登录
+ (ASAppleLoginRequest*_Nullable)createLoginRequestForController:(UIViewController*)controller;
@end



NS_ASSUME_NONNULL_END
