//
//  ASAppleLogin.m
//  ASAppleLogin
//
//  Created by 坚鹏 on 2023/6/19.
//

#import "ASAppleLogin.h"
#import <AuthenticationServices/AuthenticationServices.h>

@implementation ASAppleLogin

+(BOOL)isSupported
{
    if(@available(iOS 13.0,*)){
        return true;
    }return false;
}

+(__kindof UIView *)createAppleIdAuthorizingButtonForTarget:(id)target action:(SEL)action
{
    return [self createAppleIdAuthorizingButtonForTarget:target action:action style:ASALSystemButtonStyleBlack];
}

+ (__kindof UIView *)createAppleIdAuthorizingButtonForTarget:(id)target action:(SEL)action style:(ASALSystemButtonStyle)style
{
    if (@available(iOS 13.0, *)) {
        ASAuthorizationAppleIDButton * button = [ASAuthorizationAppleIDButton buttonWithType:ASAuthorizationAppleIDButtonTypeSignIn style:[self _convertedStyle:style]];
        [button addTarget:target action:action forControlEvents:UIControlEventTouchUpInside];
        return button;
    } else {/* not supported */}
    return nil;
}
+(ASAppleLoginRequest *)createLoginRequestForController:(UIViewController *)controller
{
    return [self isSupported]?[[ASAppleLoginRequest alloc]initWithBusinessController:controller]:nil;
}

#pragma mark - Privates
+ (ASAuthorizationAppleIDButtonStyle)_convertedStyle:(ASALSystemButtonStyle)style API_AVAILABLE(ios(13.0))
{
    if(style == ASALSystemButtonStyleWhite){
        return ASAuthorizationAppleIDButtonStyleWhite;
    }else if (style == ASALSystemButtonStyleWhiteOutline){
        return ASAuthorizationAppleIDButtonStyleWhiteOutline;
    }
    return ASAuthorizationAppleIDButtonStyleBlack;
}
@end
