//
//  ASAppleLoginRequest.m
//  ASAppleLogin
//
//  Created by 坚鹏 on 2023/6/19.
//

#import "ASAppleLoginRequest.h"
#import <AuthenticationServices/AuthenticationServices.h>

@interface ASAppleLoginRequest()<ASAuthorizationControllerDelegate, ASAuthorizationControllerPresentationContextProviding>
{
    BOOL _isStarted;
}
@property(nonatomic,weak)UIViewController * businessController;
@end

@implementation ASAppleLoginRequest

-(instancetype)initWithBusinessController:(UIViewController *)controller
{
    if(self = [super init]){
        _businessController = controller;
    }return self;
}
-(void)starts
{
    if(_isStarted){return;}
    _isStarted = true;
    if (@available(iOS 13.0, *)) {
        ASAuthorizationAppleIDProvider * appleIDProvider = [[ASAuthorizationAppleIDProvider alloc] init];
        ASAuthorizationAppleIDRequest * authAppleIDRequest = [appleIDProvider createRequest];
        ASAuthorizationPasswordRequest * passwordRequest = [[[ASAuthorizationPasswordProvider alloc] init] createRequest];

        NSMutableArray <ASAuthorizationRequest *> * array = [NSMutableArray arrayWithCapacity:2];
        if (authAppleIDRequest) {
            [array addObject:authAppleIDRequest];
        }
        NSArray <ASAuthorizationRequest *> * requests = [array copy];
        
        ASAuthorizationController * authorizationController = [[ASAuthorizationController alloc] initWithAuthorizationRequests:requests];
        authorizationController.delegate = self;
        authorizationController.presentationContextProvider = self;
        [authorizationController performRequests];
    }else{/* do nothing. */}
}
#pragma mark - ASAuthorizationControllerDelegate
// 授权成功
- (void)authorizationController:(ASAuthorizationController *)controller didCompleteWithAuthorization:(ASAuthorization *)authorization API_AVAILABLE(ios(13.0)) {
    
    if ([authorization.credential isKindOfClass:[ASAuthorizationAppleIDCredential class]]) {
        ASAuthorizationAppleIDCredential * credential = authorization.credential;
        NSString * userID = credential.user;
        NSPersonNameComponents * fullName = credential.fullName;
        NSString * email = credential.email;
        
        NSString * authorizationCode = [[NSString alloc] initWithData:credential.authorizationCode encoding:NSUTF8StringEncoding];
        NSString * identityToken = [[NSString alloc] initWithData:credential.identityToken encoding:NSUTF8StringEncoding];
        ASUserDetectionStatus realUserStatus = credential.realUserStatus;
        if(realUserStatus == ASUserDetectionStatusUnsupported){
            NSLog(@"[ASAppleLoginRequest]meet unsupported!");
        }
        ASAppleUser * user = [[ASAppleUser alloc] init];
        user.userId = userID;
        user.fullName = fullName;
        user.email = email;
        user.authCode = authorizationCode;
        user.identityToken = identityToken;
        if(self.authSuccessHandle){self.authSuccessHandle(user);}
    }
    else if ([authorization.credential isKindOfClass:[ASPasswordCredential class]]) {        
        // 用户登录使用现有的密码凭证
        ASPasswordCredential * passwordCredential = authorization.credential;
        // 密码凭证对象的用户标识 用户的唯一标识
        NSString * userID = passwordCredential.user;
        // 密码凭证对象的密码
        NSString * password = passwordCredential.password;
        ASAppleUser * user = [[ASAppleUser alloc] init];
        user.userId = userID;
        user.password = password;
        if(self.authSuccessHandle){self.authSuccessHandle(user);}
    } else {
        //preserved.
    }
}

// 授权失败
- (void)authorizationController:(ASAuthorizationController *)controller didCompleteWithError:(NSError *)error API_AVAILABLE(ios(13.0)) {
    
    NSString *errorMsg = nil;
    
    switch (error.code) {
        case ASAuthorizationErrorCanceled:
            errorMsg = @"用户取消了授权请求";
            break;
        case ASAuthorizationErrorFailed:
            errorMsg = @"授权请求失败";
            break;
        case ASAuthorizationErrorInvalidResponse:
            errorMsg = @"授权请求响应无效";
            break;
        case ASAuthorizationErrorNotHandled:
            errorMsg = @"未能处理授权请求";
            break;
        case ASAuthorizationErrorUnknown:
            errorMsg = @"授权请求失败未知原因";
            break;
    }
    if(self.authFailedHandle){self.authFailedHandle(error.code, errorMsg);}
}
#pragma mark - ASAuthorizationControllerPresentationContextProviding
- (ASPresentationAnchor)presentationAnchorForAuthorizationController:(ASAuthorizationController *)controller API_AVAILABLE(ios(13.0)){
    
    return self.businessController.view.window;
}
@end
